#!/usr/bin/env bash
source $MINER_DIR/$CUSTOM_MINER/h-manifest.conf

algo='neptune'
version="3.4.0"
stats=""
unit="M/s"
khs=0

khs=$(tail -n 100 /hive/miners/custom/nptprover/nptprover.log |grep "Total 1m speed(M/s)" | awk 'END {print}'| awk '{print $4}')

khs_num=$(echo "$khs" | jq -R . | jq -s 'map(tonumber)[0]')

stats=$(jq -nc --argjson khs "$khs_num" \
	--arg hs_units "$unit" \
	--arg ver "$version" \
	--arg algo "$algo" \
	'{"khs":$khs, "hs_units":$hs_units, "ver":$ver, "algo":$algo}')


echo "$stats"
